package w83b.w83bOperacionesPaso.w83bComunicaciones;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bComunicacionesBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bGenerarRtfAcusesRelacionAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//String strRutaRtf ="";// Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_RTF")+"plantillaCertNumDelCentSind.rtf";
		

	    List lista=(List)contexto.get("w83bResultadoBean");
		
		String idioma=(String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		W83bUsuarioXLNetsBean usuario=(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
	    HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);  	
        	
		HashMap mapaPar = new HashMap();
		
		HashMap mapaPlantillas = (HashMap)contexto.get("w83bPlantillasMap");
		byte[] plantilla = ((W83bPlantillasBean)mapaPlantillas.get(W83bClsConstantes.RELACUSES.toUpperCase())).getFichero();
		
		CharSequence content=W83bUtilidadesRTF.leerTodoFichero(plantilla);
		
		String contenido=content.toString();

		StringBuffer contenidoBuffer=new StringBuffer(contenido);
		int rep=contenido.indexOf("pnseclvl9");
		StringBuffer hastarep=new StringBuffer(contenido.substring(0,rep));
		int a=hastarep.lastIndexOf("pntxta )}}");
		int z=contenido.indexOf("themedata");
		StringBuffer parteDelanteLimpia=new StringBuffer(contenido.substring(0,a+10));
		String parteAtrasLimpia=contenido.substring(z-4,contenido.length());
		
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);
		StringBuffer datos=new StringBuffer();
		datos.append(parteDelanteLimpia);
		mapaPar.put("<<DEPEUS>>",((StringBuffer)datosDelDep.get("tituloDepEu")).toString());
		mapaPar.put("<<DEPCAS>>",((StringBuffer)datosDelDep.get("tituloDepEs")).toString());
		mapaPar.put("<<DELEUS>>",((StringBuffer)datosDelDep.get("tituloDelelegacionEu")).toString());
		mapaPar.put("<<DELCAS>>",((StringBuffer)datosDelDep.get("tituloDelelegacionEs")).toString());
		W83bClsTrazas.trazaError(null,"ttulo "+((StringBuffer)datosDelDep.get("tituloDepEs")).toString(), null);
		W83bClsTrazas.trazaError(null,"delegacin "+((StringBuffer)datosDelDep.get("tituloDelelegacionEs")).toString(), null);
		mapaPar.put("<<DIRDELEGACION>>",(String)datosDelDep.get("dirdelegacion"));
		String fecha="";
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			fecha=W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA);
		}
		else{
			fecha=W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.EU_PATTERN_HORA);
		}
		
		mapaPar.put("<<DIA>>",fecha.substring(0, fecha.length()-3));

		int numElemento=0;
		for(int i=0;i<lista.size()-1;i++)
		{
			numElemento=numElemento+1;
			W83bComunicacionesBean comunic=(W83bComunicacionesBean)lista.get(i);
			if ("preaviso".equals(lista.get(lista.size()-1))){
				mapaPar=crearRepeticion(mapaPar,comunic, "preaviso", numElemento);
			}else if ("comincidencias".equals(lista.get(lista.size()-1))){
				mapaPar=crearRepeticion(mapaPar,comunic, "incidencia", numElemento);
			}else{
				mapaPar=crearRepeticion(mapaPar,comunic, "acta", numElemento);
			}
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			datos.append(elemento);
			if ("laudo".equals(lista.get(lista.size()-1))){
				if ("1".equals(comunic.getOrderby())){
					numElemento=numElemento+1;
					mapaPar=crearRepeticion(mapaPar,comunic, "acta", numElemento);
					elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
					datos.append(elemento);
				}
				
			}
			
			
		}
		
		datos.append(parteAtrasLimpia);
		
		response.setContentType("application/msword; charset=UTF-8");
        response.setContentLength(datos.toString().getBytes().length);
        
        if ("preaviso".equals(lista.get(lista.size()-1))){
       	 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesPreavisos.rtf");
		}else if ("impug".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesImpugResueltas.rtf");
		}else if ("laudo".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesLaudosResueltos.rtf");
		}else if ("faltapre".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesFaltaPreaviso.rtf");
		}else if ("laudonegativo".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesLaudoNegativo.rtf");
		}else if ("requemesa".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesRequerimientoMesa.rtf");
		}else if ("comempresas".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesComunicacionEmpresas.rtf");
		}else if ("comincidencias".equals(lista.get(lista.size()-1))){
			 response.setHeader("Content-disposition","attachment;filename=RelacionAcusesComunicacionIncidencias.rtf");
		}
       
        response.getOutputStream().write(datos.toString().getBytes());
        response.getOutputStream().flush();
        
        return null;
	    
	}
	
	public HashMap crearRepeticion(HashMap mapaPar,W83bComunicacionesBean comunic, String tipo, int numnotif) throws NumberFormatException, Q70GestorMensajesException{
		StringBuffer numacta;
		mapaPar.put("<<ATTON>>",String.valueOf(numnotif));
		mapaPar.put("<<RAZON>>",comunic.getRazon());
		numacta=new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		if ("preaviso".equals(tipo)){
			mapaPar.put("<<NUMEXP>>",comunic.getNumpreaviso());
		}
		else if ("incidencia".equals(tipo)){
			numacta.append(comunic.getTerrit()).append("/").append(comunic.getAnoincidencia()).append("/").append(W83bUtilidades.rellenarCaracter(comunic.getNumincidencia(), "0", 6, true));
			mapaPar.put("<<NUMEXP>>",numacta.toString());
		}else{	
			numacta.append(comunic.getTerrit()).append("/").append(comunic.getAnoacta()).append("/").append(W83bUtilidades.rellenarCaracter(comunic.getNacta(), "0", 6, true));
			mapaPar.put("<<NUMEXP>>",numacta.toString());
		}
		if (W83bClsConstantes.CONSTANTE_NO_VALIDADA.equals(comunic.getCentroSel())||StringUtils.isEmpty(comunic.getDirorig())){
			mapaPar.put("<<DOMIC>>",W83bUtilidadesRTF.ponerBlancoANulo(comunic.getDomicilio()));
		}
		else{
			mapaPar.put("<<DOMIC>>",W83bUtilidadesRTF.ponerBlancoANulo(comunic.getDirorig()));
		}	
		mapaPar.put("<<MUNIC>>",W83bUtilidadesRTF.ponerBlancoANulo(comunic.getMunicipio()));
		mapaPar.put("<<PROV>>",comunic.getProvincia());
		return mapaPar;
	}	
}

